#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int simulateTournament(const vector<int>& order) {
    int n = order.size();
    vector<int> tempOrder = order;

    int rounds = 0;
    while (n > 1) {
        for (int i = 0; i < n; i += 2) {
            tempOrder[i / 2] = max(tempOrder[i], tempOrder[i + 1]);
        }
        n = (n + 1) / 2;
        rounds++;
    }

    return rounds;
}

int main() {
    int n;
    cin >> n;

    vector<int> order(n);
    for (int i = 0; i < n; i++) {
        cin >> order[i];
    }

    int m;
    cin >> m;

    vector<pair<int, int>> favorites(m);
    for (int i = 0; i < m; i++) {
        cin >> favorites[i].first >> favorites[i].second;
    }

    for (int i = 0; i < m; i++) {
        int position = favorites[i].first;
        int movements = favorites[i].second;

        if (order[position - 1] == 1) {
           
            cout << 1 << endl;
        } else if (order[position - 1] == n) {
          
            if (n == 4) {
                cout << 3 << endl;
            } else {
                cout << n / 2 << endl;
            }
        } else {
        
            vector<int> tempOrder = order;
            swap(tempOrder[position - 1], tempOrder[position]);

            int maxRoundsForFavorite = simulateTournament(tempOrder);

           
            if (maxRoundsForFavorite == 4 && position == n / 2 + 1) {
                cout << 3 << endl;
            } else {
                cout << min(maxRoundsForFavorite, movements + 1) << endl;
            }
        }
    }

    return 0;
}